within BuildingControlLib.BuildingControl.VDI3813;
package OperatorAndDisplayFunctions "Operator and display functions referring to VDI3813 directive"
  extends Modelica.Icons.VariantsPackage;





annotation (preferredView="info",Documentation(info="<html>
<p>This package contains operator and display functions described in VDI 3813 <a href=\"modelica://BuildingControlLib.UsersGuide.References\">[1]</a>:</p>
<p>&QUOT;In room control, operator functions convert operator control actions to output information which is then available as input information to the application functions. Display functions convert output information from application functions or operator functions to visual information informing the user about states of the automation system, e. g. about the controlled variable (actual value) or reference variable (setpoint) of a room temperature control (Figure 15). Operator and display functions thus form the interface for interaction between the room control system and the user.&QUOT; <a href=\"modelica://BuildingControlLib.UsersGuide.References\">[1, section 6.4.1, p. 23]</a></p>
<p><b>Fig. 1: </b>UML class diagramm of the <i>operator and display functions</i> basic design idea.<a href=\"modelica://BuildingControlLib.UsersGuide.References\">[1, section 6.4.1, p. 23]</a></p>
<table cellspacing=\"0\" cellpadding=\"2\" border=\"0\"><tr>
<td><p><img src=\"modelica://BuildingControlLib/Resources/Images/docUMLStr_OperatorDisplayFunctionConcept.png\" alt=\"docUMLStr_OperatorDisplayFunctionConcept.png\"/> </p></td>
</tr>
</table>
</html>", revisions="<html>
<ul>
<li>March 07, 2017&nbsp; by Georg Ferdinand Schneider &amp; Georg Ambrosius Pe&szlig;ler:<br>Implemented.</li>
</ul>
</html>"));
end OperatorAndDisplayFunctions;
